const express = require('express');
const { createProxyMiddleware } = require('http-proxy-middleware');

const app = express();

// Forward requests
app.use('/auth', createProxyMiddleware({ target: 'http://localhost:4001', changeOrigin: true }));
app.use('/community', createProxyMiddleware({ target: 'http://localhost:4002', changeOrigin: true }));
app.use('/rideCraft', createProxyMiddleware({ target: 'http://localhost:4003', changeOrigin: true }));


// Gateway runs on 4000
const PORT = 4000;
// 
// CRITICAL FIX: Specify '0.0.0.0' to listen on all interfaces,
// making the gateway reachable from the external network.
// 
app.listen(PORT, '0.0.0.0', () => { 
  console.log(`🚀 API Gateway running at http://0.0.0.0:${PORT}`);
});