const authService = require("./auth.service");
const jwt = require("jsonwebtoken");
const axios = require("axios");
const nodemailer = require("nodemailer");
const path = require("path");
require("dotenv").config({
  path: path.resolve(__dirname, "../../rider_connect_shared_repo/src/db_services/.env")
});

// Import response handlers from shared repo
const { success, failure, unauthorized, serverError } = require("../../rider_connect_shared_repo/src/utils/responseHandler");

const JWT_SECRET = process.env.JWT_SECRET || "rider_secret_key";

/**
 * Generate JWT token for user
 */
function generateToken(user) {
  return jwt.sign(
    { id: user.id, email: user.email, phone: user.phone },
    JWT_SECRET,
    { expiresIn: "60d" }
  );
}

/**
 * Controller functions
 */
async function userLogin(req, res) {
  try {
    const user = await authService.userLogin(req.body);
    if (!user) return unauthorized(res, "Invalid credentials");

    const token = generateToken(user);
    success(res, { user, token }, "Login successful");
  } catch (err) {
    serverError(res, err.message);
  }
}

async function checkUser(req, res) {
  try {
    const user = await authService.checkUserByPhoneOrMailOrId(req.body);
    if (!user) return failure(res, "User Not Exists");
    success(res, user, "User Exists");
  } catch (err) {
    serverError(res, err.message);
  }
}

async function register(req, res) {
  try {
    // Step 0: Check if user already exists
    const existingUser = await authService.checkUserByPhoneOrMailOrId(req.body);

    if (existingUser) {
      // User already exists, no OTP sent
      return res.status(400).json({
        status: "error",
        message: "User already exists",
        data: null
      });
    }

    // Step 1: Register new user
    const user = await authService.register(req.body);

    // Step 2: Generate 6-digit OTP
    const otp = Math.floor(1000 + Math.random() * 9000).toString();
    let smsSent = false;

    // Step 3: Send OTP via SMS if phone provided
    if (req.body.phone) {
      const smsText = `RiderConnect Login otp: ${otp} is your OTP for mobile number verification. Valid for 2 min. 
RiderConnect. 
chennaiepc`;

      const smsUrl = `https://online.chennaisms.com/api/mt/SendSMS`;

      const params = {
        user: "bookmesocialcom",
        password: "india123",
        senderid: "CHNNAI",
        channel: "Trans",
        DCS: "0",
        flashsms: "0",
        number: `91${req.body.phone}`,
        text: smsText,
      };

      try {
        const response = await axios.get(smsUrl, { params });
        console.log("📩 SMS API Response:", response.data);

        if (response.data?.ErrorCode === "000") {
          await authService.updateUserOtp({ phone: req.body.phone, otp });

          smsSent = true;
        } else {
          console.error("❌ SMS failed:", response.data?.ErrorMessage);
        }
      } catch (error) {

        if (error.response) console.error("Response Data:", error.response.data);
      }
    }

    // Step 4: Send OTP via Email if provided
    if (req.body.email) {
      try {
        const transporter = nodemailer.createTransport({
          service: "gmail",
          auth: {
            user: "auth.riderconnect@gmail.com",
            pass: "ccsojjbedzuxxdao", // Gmail App Password
          },
        });

        const mailOptions = {
          from: '"RiderConnect" <auth.riderconnect@gmail.com>',
          to: req.body.email,
          subject: "RiderConnect OTP Verification",
          text: `Your RiderConnect OTP is ${otp}. It is valid for 2 minutes.`,
        };

        await transporter.sendMail(mailOptions);

        // Update OTP in DB if SMS not sent
        if (!smsSent) {
          await authService.updateUserOtp({ email: req.body.email, otp });

        }

      } catch (mailErr) {
        console.error("❌ Email sending failed:", mailErr.message);
      }
    }

    // Step 5: Respond to client
    res.status(200).json({
      status: "success",
      message: "OTP sent successfully via SMS and/or Email",
      data: user
    });

  } catch (err) {
    console.error("Server Error:", err.message);
    res.status(500).json({
      status: "error",
      message: err.message,
      data: null
    });
  }
}

async function resendOtp(req, res) {
  try {
    // Step 1: Check if user exists
    const existingUser = await authService.checkUserByPhoneOrMailOrId(req.body);

    if (!existingUser) {
      return res.status(400).json({
        status: "error",
        message: "User not found. Please register first.",
        data: null,
      });
    }

    // Step 2: Generate new 4-digit OTP
    const otp = Math.floor(1000 + Math.random() * 9000).toString();
    let smsSent = false;

    // Step 3: Send OTP via SMS if phone exists
    if (req.body.phone) {
      const smsText = `RiderConnect Login OTP: ${otp} is your OTP for mobile number verification. Valid for 2 min.
RiderConnect.
chennaiepc`;

      const smsUrl = `https://online.chennaisms.com/api/mt/SendSMS`;

      const params = {
        user: "bookmesocialcom",
        password: "india123",
        senderid: "CHNNAI",
        channel: "Trans",
        DCS: "0",
        flashsms: "0",
        number: `91${req.body.phone}`,
        text: smsText,
      };

      try {
        const response = await axios.get(smsUrl, { params });


        if (response.data?.ErrorCode === "000") {
          await authService.updateUserOtp({ phone: req.body.phone, otp });
          smsSent = true;
        } else {
          console.error("❌ SMS failed:", response.data?.ErrorMessage);
        }
      } catch (error) {
        console.error("❌ SMS sending error:", error.message);
        if (error.response) console.error("Response Data:", error.response.data);
      }
    }

    // Step 4: Send OTP via Email if email provided
    if (req.body.email) {
      try {
        const transporter = nodemailer.createTransport({
          service: "gmail",
          auth: {
            user: "auth.riderconnect@gmail.com",
            pass: "ccsojjbedzuxxdao", // Gmail App Password
          },
        });

        const mailOptions = {
          from: '"RiderConnect" <auth.riderconnect@gmail.com>',
          to: req.body.email,
          subject: "RiderConnect OTP Verification",
          text: `Your RiderConnect OTP is ${otp}. It is valid for 2 minutes.`,
        };

        await transporter.sendMail(mailOptions);

        // Update OTP in DB if SMS not sent
        if (!smsSent) {
          await authService.updateUserOtp({ email: req.body.email, otp });
        }
      } catch (mailErr) {
        console.error("❌ Email sending failed:", mailErr.message);
      }
    }

    // Step 5: Respond to client
    res.status(200).json({
      status: "success",
      message: "OTP resent successfully via SMS and/or Email",
      data: existingUser,
    });
  } catch (err) {
    console.error("Server Error:", err.message);
    res.status(500).json({
      status: "error",
      message: err.message,
      data: null,
    });
  }
}



async function resetPasswordSendOtp(req, res) {
  try {
    const existingUser = await authService.checkUserByPhoneOrMailOrId(req.body);

    if (!existingUser) {
      return res.status(400).json({
        status: "error",
        message: "User not exists",
        data: null
      });
    }

    // Generate 4-digit OTP
    const otp = Math.floor(1000 + Math.random() * 9000).toString();
    let smsSent = false;

    // Send OTP via SMS if phone provided
    if (req.body.phone) {
      const smsText = `RiderConnect Login OTP: ${otp} is your OTP for mobile number verification. Valid for 2 min.\nRiderConnect.\nchennaiepc`;

      const smsUrl = `https://online.chennaisms.com/api/mt/SendSMS`;
      const params = {
        user: "bookmesocialcom",
        password: "india123",
        senderid: "CHNNAI",
        channel: "Trans",
        DCS: "0",
        flashsms: "0",
        number: `91${req.body.phone}`,
        text: smsText,
      };

      try {
        const response = await axios.get(smsUrl, { params });
        console.log("📩 SMS API Response:", response.data);

        if (response.data?.ErrorCode === "000") {
          await authService.updateUserOtp({ phone: req.body.phone, otp });
          smsSent = true;
        } else {
          console.error("❌ SMS failed:", response.data?.ErrorMessage);
        }
      } catch (error) {
        if (error.response) console.error("Response Data:", error.response.data);
      }
    }

    // Send OTP via email if email provided
    if (req.body.email) {
      try {
        const transporter = nodemailer.createTransport({
          service: "gmail",
          auth: {
            user: "auth.riderconnect@gmail.com",
            pass: "ccsojjbedzuxxdao", // Gmail App Password
          },
        });

        const mailOptions = {
          from: '"RiderConnect" <auth.riderconnect@gmail.com>',
          to: req.body.email,
          subject: "RiderConnect OTP Verification",
          text: `Your RiderConnect OTP is ${otp}. It is valid for 2 minutes.`,
        };

        await transporter.sendMail(mailOptions);

        if (!smsSent) {
          await authService.updateUserOtp({ email: req.body.email, otp });
        }

      } catch (mailErr) {
        console.error("❌ Email sending failed:", mailErr.message);
      }
    }

    // ✅ Send response with correct variable
    res.status(200).json({
      status: "success",
      message: "OTP sent successfully via SMS and/or Email",
      data: existingUser,
    });

  } catch (err) {
    console.error("Server Error:", err.message);
    res.status(500).json({
      status: "error",
      message: err.message,
      data: null,
    });
  }
}


async function verifyOtp(req, res) {
  try {
    const user = await authService.verifyOtp(req.body);
    if (!user) return unauthorized(res, "Invalid credentials");

    const token = generateToken(user);
    success(res, { user, token }, "OTP verified successfully");
  } catch (err) {
    serverError(res, err.message);
  }
}

async function setProfileDetails(req, res) {
  try {
    const user = await authService.setProfile(req.body);
    if (!user) return failure(res, "Profile update failed");
    const token = generateToken(user);
    success(res, { user, token }, "Profile updated successfully");
  } catch (err) {
    serverError(res, err.message);
  }
}

async function setVehicleData(req, res) {
  try {
    const vehicle = await authService.setVehicleData(req.body);
    if (!vehicle) return failure(res, "Vehicle details not added");

    success(res, vehicle, "Vehicle details added successfully");
  } catch (err) {
    serverError(res, err.message);
  }
}

async function getUserVehicles(req, res) {
  try {
    const user_id = req.params.id;
    if (!user_id) return res.status(400).json({ message: "User ID is required." });

    const vehicle = await authService.findUserVehicleService({ user_id });

    if (!vehicle || vehicle.length === 0) {
      return success(res, {}, "Failed");
    }

    return success(res, vehicle, "Vehicles Fetched Successfully");
  } catch (error) {
    serverError(res, error.message);
  }
}


async function updatePassword(req, res) {
  try {
    const { id, password } = req.body;

    if (!id || !password) {
      return badRequest(res, "User ID and new password are required");
    }

    const user = await authService.updatePasswordService({ id, password });
    if (!user) return notFound(res, "User not found");

    const token = generateToken(user);

    success(res, { user, token }, "Password updated successfully");
  } catch (error) {
    serverError(res, error.message);
  }
}


module.exports = {
  userLogin, register, verifyOtp, setProfileDetails, setVehicleData,
  updatePassword, getUserVehicles, checkUser, resetPasswordSendOtp,resendOtp
};

































