const express = require("express");
const router = express.Router();
const authController = require("./auth.controller");
const {authorize}  = require("../../rider_connect_shared_repo/src/utils/jwt.middleware");



router.post("/login", authController.userLogin);
router.post("/register", authController.register);
router.post("/verify_otp",authController.verifyOtp);
router.post("/request_password_reset",authController.resetPasswordSendOtp);
router.post("/update_password",authController.updatePassword);
router.post("/resend_otp",authController.resendOtp);

// Protected routes

router.post("/check_user",authController.checkUser);
router.post("/set_profile",authController.setProfileDetails);
router.post("/set_vehicle_data",authController.setVehicleData);
router.get("/get_vehicle_data/:id",authController.getUserVehicles);



module.exports = router;
