const {
    findUserByEmailOrMobileAndPassword,
    createUser,
    updateOtp,
    otpVerify,
    setupProfile,
    setVehicleDetail,
    findUserByEmailPhoneId, findUserVehicle,updatePassword
} = require("../../rider_connect_shared_repo/src/db_services/functions/auth-functions/auth.function");

/**
 * User Login
 */
async function userLogin(data) {
    return await findUserByEmailOrMobileAndPassword(data);
}

async function checkUserByPhoneOrMailOrId(data) {
    return await findUserByEmailPhoneId(data);
}

/**
 * User Registration
 */
async function register(data) {
    return await createUser(data);
}

/**
 * Update OTP
 */
async function updateUserOtp(data) {
    return await updateOtp(data);
}

/**
 * Verify OTP
 */
async function verifyOtp(data) {
    return await otpVerify(data);
}

/**
 * Setup / Update User Profile
 */
async function setProfile(data) {
    return await setupProfile(data);
}

/**
 * Set Vehicle Details
 */
async function setVehicleData(data) {
    return await setVehicleDetail(data);
}

async function requestPasswordReset(data) {
    return await findUserByEmailPhoneId(data);
}

async function findUserVehicleService(data) {
    return await findUserVehicle(data);
}

async function updatePasswordService(data) {
    return await updatePassword(data);
}

module.exports = { checkUserByPhoneOrMailOrId, userLogin, register, updateUserOtp, verifyOtp, setProfile, setVehicleData, requestPasswordReset, updatePasswordService, findUserVehicleService };




































// const {
//     findUserByEmailOrMobileAndPassword,
//     createUser, updateOtp, otpVerify, setupProfile, setVehicleDetail
// } = require("rider_connect_shared_repo/src/db_services/functions/auth-functions");

// async function userLogin(email, phone, password) {
//     return await findUserByEmailOrMobileAndPassword(email, phone, password);
// }

// async function register(email, phone, password) {
//     return await createUser(email, phone, password);
// }

// async function updateUserOtp(otp) {
//     return await updateOtp(otp);
// }

// async function verifyOtp(id, otp) {
//     return await otpVerify({ id, otp });
// }

// async function setProfile({ id, first_name, last_name, user_name, gender, dob }) {
//     return await setupProfile({ id, first_name, last_name, user_name, gender, dob });
// }

// async function setVehicleData({ vehicle_type,
//     vehicle_brand,
//     model,
//     registration_number,
//     dl_number,
//     user_id }) {
//     return await setVehicleDetail({
//         vehicle_type,
//         vehicle_brand,
//         model,
//         registration_number,
//         dl_number,
//         user_id
//     });
// }

// module.exports = { userLogin, register, updateUserOtp, verifyOtp, setProfile, setVehicleData };
