const express = require("express");
const router = express.Router();
const clubController = require("./club.controller");
// const {authorize}  = require("../../rider_connect_shared_repo/src/utils/jwt.middleware");


router.post("/create_club",clubController.createClubController)
router.post("/join_club",clubController.joinClubController);
router.patch("/update_club/:id",clubController.updateClubController);
router.get("/club_detail/:id",clubController.getClubByIdController);
router.get("/my_clubs/:id",clubController.getMyClubsController);
router.get("/club_members/:id",clubController.getClubMembersController);
router.post("/create_club_post",clubController.createClubPostController);
router.get("/club_post/:id",clubController.getClubPostController);
router.post("/create_leaderboard",clubController.createLeaderBoardController);
router.get("/leaderboard/:id",clubController.getLeaderBoardController);
router.get("/explore_clubs/:id",clubController.exploreClubController);
router.get("/club_events/:id",clubController.getClubEventsController);
router.get("/requested_clubs/:id",clubController.requestedClubsController);
router.post("/club_post_like",clubController.clubPostLikeController);
router.delete("/club_post_unlike/:id",clubController.clubPostUnlikeController);
router.post("/comment_club_post",clubController.commentClubPostController);
router.delete("/delete_club_post_comment/:id",clubController.deleteCommentController);

module.exports = router;
