const { createClubFunction, joinClubFunction, updateClubFunction, getClubByIdFunction, getMyClubsFunction,
    getClubMembersFunction, createClubPostFunction, getClubPostFunction, createLeaderBoardFunction, getClubLeaderBoardFunction,
    getClubEventsFunction, exploreClubFunction,
    requestedClubsFunction,
    clubPostLikeFunction,
    clubPostUnlikeFunction, commentClubPostFunction, deleteCommentFunction
} = require("../../../rider_connect_shared_repo/src/db_services/functions/community-functions/club.function");


async function createClubService(data) {
    return await createClubFunction(data);
}

async function updateClubService(id, data) {
    return await updateClubFunction(id, data);
}

async function getClubByIdService(id) {
    return await getClubByIdFunction(id);
}

async function getMyClubsService(user_id) {
    return await getMyClubsFunction(user_id);
}

async function getClubMembersService(club_id) {
    return await getClubMembersFunction(club_id);
}

async function createClubPostService(data) {
    return await createClubPostFunction(data);
}

async function getClubPostService(club_id) {
    return await getClubPostFunction(club_id);
}

async function createLeaderBoardService(data) {
    return await createLeaderBoardFunction(data);
}

async function joinClubService(data) {
    return await joinClubFunction(data);
}

async function getLeaderBoardService(club_id) {
    return await getClubLeaderBoardFunction(club_id);
}

async function exploreClubService(user_id) {
    return await exploreClubFunction(user_id);
}

async function requestedClubsService(user_id) {
    return await requestedClubsFunction(user_id);
}

async function getClubEventsService(club_id) {
    return await getClubEventsFunction(club_id);
}

async function clubPostLikeService(data) {
    return await clubPostLikeFunction(data);
}

async function clubPostUnlikeService(id) {
    return await clubPostUnlikeFunction(id);
}

async function commentClubPostService(data) {
    return await commentClubPostFunction(data);
}

async function deleteCommentService(id) {
    return await deleteCommentFunction(id);
}

module.exports = {
    createClubService,
    updateClubService,
    getClubByIdService,
    getMyClubsService,
    getClubMembersService,
    createClubPostService,
    getClubPostService,
    createLeaderBoardService,
    joinClubService,
    getLeaderBoardService,
    exploreClubService,
    requestedClubsService,
    getClubEventsService,
    clubPostLikeService,
    clubPostUnlikeService,
    commentClubPostService,
    deleteCommentService
}