const { createGroupFunction, joinGroupFunction, requestedGroupsFunction, exploreGroupsFunction, getMyGroupsFunction,
    getGroupMembersFunction,
    getGroupEventsFunction
} = require("../../../rider_connect_shared_repo/src/db_services/functions/community-functions/group.function");


async function createGroupService(data) {
    return await createGroupFunction(data);
}

async function joinGroupService(data) {
    return await joinGroupFunction(data);
}

async function requestedGroupsService(user_id) {
    return await requestedGroupsFunction(user_id);
}

async function exploreGroupsService(user_id) {
    return await exploreGroupsFunction(user_id);
}

async function getMyGroupsService(user_id) {
    return await getMyGroupsFunction(user_id);
}

async function getGroupMembersService(group_id) {
    return await getGroupMembersFunction(group_id);
}

async function getGroupEventsService(group_id) {
    return await getGroupEventsFunction(group_id);
}


module.exports = {
    createGroupService,
    joinGroupService,
    requestedGroupsService,
    exploreGroupsService,
    getMyGroupsService,
    getGroupMembersService,
    getGroupEventsService
}