const model = require("../../models");
const { Op, where } = require("sequelize");

const user = model.User;
const events_rides_master = model.events_rides_master;
const event_members = model.event_members;
const event_posts = model.event_posts;

async function createEventRideFunction(data) {
    const event = await events_rides_master.create(data);
    return event;
}

async function getEventByIdFunction(event_id) {
    const event = await events_rides_master.findByPk(event_id);
    return event;
}

async function joinEvnentFunction(data) {
    const event = await event_members.create(data);
    return event;
}

async function getEventMembersFunction(event_id) {
    const memberships = await event_members.findAll({
        where: { event_id },
        attributes: ["user_id", "role", "event_id"]
    });

    if (!memberships || memberships.length === 0) return [];

    const user_ids = memberships.map(m => m.user_id);

    const users = await user.findAll({
        where: { id: { [Op.in]: user_ids } },
        attributes: ["id", "first_name", "last_name", "email", "phone"]
    });

    const membersWithDetails = memberships.map(m => {
        const u = users.find(user => user.id === m.user_id);
        return {
            user_id: u.id,
            first_name: u.first_name,
            last_name: u.last_name,
            email: u.email,
            mobile: u.phone,
            role: m.role,
            event_id: m.event_id
        };
    });

    return membersWithDetails;
}

async function createEventPostFunction(data) {
    const post = await event_posts.create(data);
    return post;
}

async function getAllEventPostFunction(event_id){
    const post=await event_posts.findAll({where:{event_id}});
    return post;
}


module.exports = {
    createEventRideFunction,
    getEventByIdFunction,
    joinEvnentFunction,
    getEventMembersFunction,
    createEventPostFunction,
    getAllEventPostFunction
}