const model = require("../../models");
const { Op, where } = require("sequelize");

const user = model.User;
const events_rides_master = model.events_rides_master;
const group_master = model.group_master;
const group_members = model.group_members;


async function createGroupFunction(data) {
    const group = await group_master.create(data);
    return group;
}

async function joinGroupFunction(data) {
    const group = await group_members.create(data);
    return group;
}


async function requestedGroupsFunction(user_id) {
    try {
        const requestedGroups = await group_members.findAll({
            where: {
                user_id,
                is_approved: false
            },
            attributes: ["group_id"],
            raw: true
        });

        const groupIds = requestedGroups.map(g => g.group_id);

        if (groupIds.length === 0) {
            return [];
        }

        const groups = await group_master.findAll({
            where: {
                id: {
                    [Op.in]: groupIds
                }
            }
        });

        return groups;
    } catch (error) {
        throw error;
    }
}

async function exploreGroupsFunction(user_id) {
    try {
        const userGroups = await group_members.findAll({
            where: { user_id },
            attributes: ["group_id"],
            raw: true
        });

        const joinedGroupIds = userGroups.map(g => g.group_id);

        const groups = await group_master.findAll({
            where: {
                id: {
                    [Op.notIn]: joinedGroupIds.length > 0 ? joinedGroupIds : [0]
                }
            }
        });

        return groups;
    } catch (error) {

        throw error;
    }
}

async function getMyGroupsFunction(user_id) {

    const members = await group_members.findAll({
        where: { user_id },
        attributes: ["group_id"]
    });

    if (!members || members.length === 0) return [];

    const groupIds = members.map(m => m.group_id);

    const groups = await group_master.findAll({
        where: {
            id: { [Op.in]: groupIds }
        }
    });

    return groups;
}

async function getGroupMembersFunction(group_id) {
    const memberships = await group_members.findAll({
        where: { group_id },
        attributes: ["user_id", "role", "group_id"]
    });

    if (!memberships || memberships.length === 0) return [];

    const user_ids = memberships.map(m => m.user_id);

    const users = await user.findAll({
        where: { id: { [Op.in]: user_ids } },
        attributes: ["id", "first_name", "last_name", "user_name", "email", "phone"]
    });

    const membersWithDetails = memberships.map(m => {
        const u = users.find(user => user.id === m.user_id);
        return {
            user_id: u.id,
            first_name: u.first_name,
            last_name: u.last_name,
            user_name: u.user_name,
            email: u.email,
            mobile: u.phone,
            role: m.role,
            group_id: m.group_id
        };
    });

    return membersWithDetails;
}

async function getGroupEventsFunction(group_id){
     const club=await events_rides_master.findAll({where:{mentioned_group:group_id}});
     return club;
}

module.exports = {
    createGroupFunction,
    joinGroupFunction,
    requestedGroupsFunction,
    exploreGroupsFunction,
    getMyGroupsFunction,
    getGroupMembersFunction,
    getGroupEventsFunction
}