'use strict';
/** @type {import('sequelize-cli').Migration} */
module.exports = {
  async up(queryInterface, Sequelize) {
    await queryInterface.createTable('club_data', {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: Sequelize.INTEGER
      },
      club_mode: {
        type: Sequelize.STRING
      },
      club_logo_url: {
        type: Sequelize.STRING
      },
      club_cover_image_url: {
        type: Sequelize.STRING
      },
      club_name: {
        type: Sequelize.STRING
      },
      club_motto: {
        type: Sequelize.STRING
      },
      description: {
        type: Sequelize.TEXT
      },
      club_vision: {
        type: Sequelize.TEXT
      },
      club_goal: {
        type: Sequelize.TEXT
      },
      location: {
        type: Sequelize.STRING
      },
      language: {
        type: Sequelize.STRING
      },
      rules_regulations: {
        type: Sequelize.STRING
      },
      driving_license: {
        type: Sequelize.STRING
      },
      club_privacy_type: {
        type: Sequelize.STRING
      },
      gender: {
        type: Sequelize.STRING
      },
      gender_restriction: {
        type: Sequelize.STRING
      },
      limit_registration: {
        type: Sequelize.BOOLEAN
      },
      club_joining_fee: {
        type: Sequelize.STRING
      },
      is_approved: {
        type: Sequelize.BOOLEAN
      },
      admin: {
        type: Sequelize.STRING
      },
      is_active: {
        type: Sequelize.BOOLEAN
      },
      createdAt: {
        allowNull: false,
        type: Sequelize.DATE
      },
      updatedAt: {
        allowNull: false,
        type: Sequelize.DATE
      }
    });
  },
  async down(queryInterface, Sequelize) {
    await queryInterface.dropTable('club_data');
  }
};