'use strict';
/** @type {import('sequelize-cli').Migration} */
module.exports = {
  async up(queryInterface, Sequelize) {
    await queryInterface.createTable('events_rides_masters', {
      id: {
        allowNull: false,
        autoIncrement: true,
        primaryKey: true,
        type: Sequelize.INTEGER
      },
      event_image_url: {
        type: Sequelize.STRING
      },
      event_name: {
        type: Sequelize.STRING
      },
      description: {
        type: Sequelize.TEXT
      },
      location: {
        type: Sequelize.STRING
      },
      event_type: {
        type: Sequelize.STRING
      },
      start_date: {
        type: Sequelize.DATE
      },
      end_date: {
        type: Sequelize.DATE
      },
      start_time: {
        type: Sequelize.STRING
      },
      end_time: {
        type: Sequelize.STRING
      },
      riding_skill: {
        type: Sequelize.STRING
      },
      is_limit: {
        type: Sequelize.BOOLEAN
      },
      bike_cc: {
        type: Sequelize.STRING
      },
      mentioned_club: {
        type: Sequelize.STRING
      },
      mentioned_group: {
        type: Sequelize.STRING
      },
      reg_start_date: {
        type: Sequelize.DATE
      },
      reg_fee: {
        type: Sequelize.INTEGER
      },
      rsvp: {
        type: Sequelize.BOOLEAN
      },
      contact_person: {
        type: Sequelize.STRING
      },
      contact: {
        type: Sequelize.STRING
      },
      is_active: {
        type: Sequelize.BOOLEAN
      },
      is_approved: {
        type: Sequelize.STRING
      },
      event_code: {
        type: Sequelize.STRING
      },
      user_id: {
        type: Sequelize.STRING
      },
      createdAt: {
        allowNull: false,
        type: Sequelize.DATE
      },
      updatedAt: {
        allowNull: false,
        type: Sequelize.DATE
      }
    });
  },
  async down(queryInterface, Sequelize) {
    await queryInterface.dropTable('events_rides_masters');
  }
};