const jwt = require("jsonwebtoken");
require("dotenv").config({
  path: require("path").resolve(__dirname, "../db_services/.env")
});

const { unauthorized, serverError } = require("./responseHandler");

const JWT_SECRET = process.env.JWT_SECRET || "rider_secret_key";

/**
 * JWT Authentication middleware
 */
function authorize(req, res, next) {
  try {
    const authHeader = req.headers["authorization"];
    if (!authHeader) return unauthorized(res, "Authorization header missing");

    const token = authHeader.split(" ")[1]; 
    if (!token) return unauthorized(res, "Token missing");

    jwt.verify(token, JWT_SECRET, (err, decoded) => {
      if (err) return unauthorized(res, "Invalid or expired token");

      req.user = decoded;
      next();
    });
  } catch (err) {
    serverError(res, err.message);
  }
}

module.exports = { authorize };
