
/**
 * Success Response
 * @param {Object} res - Express response object
 * @param {Object} data - Payload to send
 * @param {string} message - Success message
 * @param {number} statusCode - HTTP status code (default 200)
 */
function success(res, data = {}, message = "Success", statusCode = 200) {
  return res.status(statusCode).json({
    status: "success",
    message,
    data
  });
}

/**
 * Failure Response
 * @param {Object} res - Express response object
 * @param {string} message - Error message
 * @param {number} statusCode - HTTP status code (default 400)
 */
function failure(res, message = "Request failed", statusCode = 400) {
  return res.status(statusCode).json({
    status: "fail",
    message,
    data: null
  });
}

/**
 * Unauthorized Response
 * @param {Object} res - Express response object
 * @param {string} message - Unauthorized message
 */
function unauthorized(res, message = "Unauthorized") {
  return res.status(401).json({
    status: "fail",
    message,
    data: null
  });
}

/**
 * Server Error Response
 * @param {Object} res - Express response object
 * @param {string} message - Error message
 */
function serverError(res, message = "Internal Server Error") {
  return res.status(500).json({
    status: "error",
    message,
    data: null
  });
}

module.exports = {
  success,
  failure,
  unauthorized,
  serverError
};
